-- serverinstance properties
insert into instance_properties (server_id, id, ident, value) values (0, 0, "serverinstance_filetransfer_port", "30033");
insert into instance_properties (server_id, id, ident, value) values (0, 0, "serverinstance_guest_serverquery_group", "1");
insert into instance_properties (server_id, id, ident, value) values (0, 0, "serverinstance_max_download_total_bandwidth", "-1");
insert into instance_properties (server_id, id, ident, value) values (0, 0, "serverinstance_max_upload_total_bandwidth", "-1");
insert into instance_properties (server_id, id, ident, value) values (0, 0, "serverinstance_template_serveradmin_group", "3");
insert into instance_properties (server_id, id, ident, value) values (0, 0, "serverinstance_template_serverdefault_group", "5");
insert into instance_properties (server_id, id, ident, value) values (0, 0, "serverinstance_template_channeladmin_group", "1");
insert into instance_properties (server_id, id, ident, value) values (0, 0, "serverinstance_template_channeldefault_group", "4");
insert into instance_properties (server_id, id, ident, value) values (0, 0, "serverinstance_permissions_version", "19");

-- bindings
insert into bindings (ip, type) values ("0.0.0.0", 0);
insert into bindings (ip, type) values ("0.0.0.0", 1);
insert into bindings (ip, type) values ("0.0.0.0", 2);

--default server properties
insert into server_properties (server_id, id, ident, value) values (0, 0, "virtualserver_name", "TeamSpeak ]I[ Server");
insert into server_properties (server_id, id, ident, value) values (0, 0, "virtualserver_welcomemessage", "Welcome to TeamSpeak, check [URL]www.teamspeak.com[/URL] for latest information");
insert into server_properties (server_id, id, ident, value) values (0, 0, "virtualserver_maxclients", "32");
insert into server_properties (server_id, id, ident, value) values (0, 0, "virtualserver_max_download_total_bandwidth", "-1");
insert into server_properties (server_id, id, ident, value) values (0, 0, "virtualserver_max_upload_total_bandwidth", "-1");

-- default servergroups
insert into groups_server (server_id, name, type) values (0, "Guest Server Query", 2);
insert into groups_server (server_id, name, type) values (0, "Admin Server Query", 2);
insert into groups_server (server_id, name, type) values (0, "Server Admin", 0);
insert into groups_server (server_id, name, type) values (0, "Normal", 0);
insert into groups_server (server_id, name, type) values (0, "Guest", 0);

-- default channelgroups
insert into groups_channel (server_id, name, type) values (0, "Channel Admin", 0);
insert into groups_channel (server_id, name, type) values (0, "Operator", 0);
insert into groups_channel (server_id, name, type) values (0, "Voice", 0);
insert into groups_channel (server_id, name, type) values (0, "Guest", 0);

-- adds a default serverquery user
insert into clients (server_id, client_unique_id, client_nickname, client_login_name, client_login_password, client_lastconnected, client_totalconnections) values (0, "serveradmin", "serveradmin", "serveradmin", "wedontwantanyoneloginshere", 0, 0); 
insert into group_server_to_client (group_id, server_id, id1, id2) values (2, 0, 1, 0);

/*BEGIN AUTOCODE*/
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_serverinstance_help_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_serverinstance_version_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_serverquery_login", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_virtualserver_select", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "i_client_needed_permission_modify_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "i_group_auto_update_type", 20, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "i_group_needed_modify_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_create_child", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_create_modify_with_codec_celtmono48", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_create_modify_with_codec_opusmusic", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_create_modify_with_codec_opusvoice", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_create_modify_with_codec_speex16", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_create_modify_with_codec_speex32", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_create_modify_with_codec_speex8", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_create_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_create_private", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_create_semi_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_create_temporary", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_create_with_default", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_create_with_description", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_create_with_maxclients", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_create_with_maxfamilyclients", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_create_with_needed_talk_power", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_create_with_password", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_create_with_sortorder", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_create_with_topic", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_delete_flag_force", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_delete_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_delete_semi_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_delete_temporary", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_info_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_join_ignore_maxclients", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_join_ignore_password", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_join_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_join_semi_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_join_temporary", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_modify_codec", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_modify_codec_latency_factor", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_modify_codec_quality", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_modify_description", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_modify_make_default", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_modify_make_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_modify_make_semi_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_modify_make_temporary", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_modify_maxclients", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_modify_maxfamilyclients", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_modify_name", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_modify_needed_talk_power", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_modify_parent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_modify_password", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_modify_sortorder", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_modify_temp_delete_delay", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_channel_modify_topic", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_avatar_delete_other", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_ban_create", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_ban_delete", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_ban_delete_own", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_ban_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_channel_textmessage_send", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_complain_delete", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_complain_delete_own", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_complain_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_create_modify_serverquery_login", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_custom_info_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_delete_dbproperties", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_ignore_antiflood", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_ignore_bans", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_ignore_sticky", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_info_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_issue_client_query_command", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_modify_dbproperties", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_modify_description", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_modify_own_description", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_offline_textmessage_send", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_permissionoverview_own", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_permissionoverview_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_remoteaddress_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_request_talker", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_server_textmessage_send", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_set_flag_talker", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_skip_channelgroup_permissions", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_use_channel_commander", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_client_use_reserved_slot", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_ft_ignore_password", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_ft_transfer_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_group_is_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_icon_manage", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_permission_modify_power_ignore", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_serverinstance_binding_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_serverinstance_help_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_serverinstance_info_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_serverinstance_log_add", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_serverinstance_log_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_serverinstance_modify_querygroup", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_serverinstance_modify_settings", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_serverinstance_modify_templates", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_serverinstance_permission_find", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_serverinstance_permission_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_serverinstance_stop", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_serverinstance_textmessage_send", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_serverinstance_version_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_serverinstance_virtualserver_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_serverquery_login", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_change_machine_id", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_change_template", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_channelclient_permission_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_channelgroup_client_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_channelgroup_create", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_channelgroup_delete", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_channelgroup_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_channelgroup_permission_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_channel_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_channel_permission_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_channel_search", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_client_dbinfo", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_client_dblist", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_client_dbsearch", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_client_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_client_permission_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_client_search", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_connectioninfo_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_create", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_custom_search", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_delete", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_info_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_join_ignore_password", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_log_add", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_log_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_antiflood", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_autostart", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_channel_forced_silence", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_channel_temp_delete_delay_default", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_codec_encryption_mode", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_complain", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_default_channeladmingroup", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_default_channelgroup", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_default_servergroup", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_ft_quotas", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_ft_settings", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_hostbanner", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_hostbutton", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_hostmessage", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_icon_id", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_log_settings", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_maxclients", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_min_client_version", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_name", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_needed_identity_security_level", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_password", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_port", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_priority_speaker_dimm_modificator", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_reserved_slots", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_temporary_passwords", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_weblist", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_modify_welcomemessage", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_notify_register", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_notify_unregister", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_permission_find", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_permission_reset", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_select", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_servergroup_client_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_servergroup_create", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_servergroup_delete", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_servergroup_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_servergroup_permission_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_snapshot_create", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_snapshot_deploy", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_start", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_start_any", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_stop", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_stop_any", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_token_add", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_token_delete", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_token_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "b_virtualserver_token_use", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_channel_create_modify_with_codec_latency_factor_min", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_channel_create_modify_with_codec_maxquality", 10, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_channel_create_modify_with_temp_delete_delay", 86400, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_channel_delete_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_channel_description_view_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_channel_join_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_channel_max_depth", -1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_channel_modify_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_channel_permission_modify_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_channel_subscribe_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_ban_max_bantime", -1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_ban_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_complain_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_kick_from_channel_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_kick_from_server_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_max_channel_subscriptions", -1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_max_clones_uid", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_move_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_needed_ban_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_needed_complain_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_needed_kick_from_channel_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_needed_kick_from_server_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_needed_move_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_needed_permission_modify_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_needed_poke_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_needed_private_textmessage_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_needed_serverquery_view_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_permission_modify_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_poke_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_private_textmessage_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_client_serverquery_view_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_ft_directory_create_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_ft_file_browse_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_ft_file_delete_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_ft_file_download_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_ft_file_rename_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_ft_file_upload_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_ft_quota_mb_download_per_client", -1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_ft_quota_mb_upload_per_client", -1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_group_auto_update_max_value", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_group_auto_update_type", 50, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_group_member_add_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_group_member_remove_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_group_modify_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_group_needed_member_add_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_group_needed_member_remove_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_group_needed_modify_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_icon_id", 500, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_max_icon_filesize", 8192, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_child", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_modify_with_codec_celtmono48", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_modify_with_codec_latency_factor_min", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_modify_with_codec_maxquality", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_modify_with_codec_opusmusic", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_modify_with_codec_opusvoice", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_modify_with_codec_speex16", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_modify_with_codec_speex32", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_modify_with_codec_speex8", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_modify_with_force_password", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_modify_with_temp_delete_delay", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_permanent", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_private", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_semi_permanent", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_temporary", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_with_default", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_with_description", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_with_maxclients", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_with_maxfamilyclients", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_with_needed_talk_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_with_password", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_with_sortorder", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_create_with_topic", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_delete_flag_force", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_delete_permanent", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_delete_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_delete_semi_permanent", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_delete_temporary", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_description_view_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_group_inheritance_end", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_info_view", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_join_ignore_maxclients", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_join_ignore_password", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_join_permanent", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_join_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_join_semi_permanent", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_join_temporary", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_max_depth", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_min_depth", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_modify_codec", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_modify_codec_latency_factor", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_modify_codec_quality", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_modify_description", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_modify_make_codec_encrypted", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_modify_make_default", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_modify_make_permanent", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_modify_make_semi_permanent", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_modify_make_temporary", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_modify_maxclients", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_modify_maxfamilyclients", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_modify_name", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_modify_needed_talk_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_modify_parent", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_modify_password", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_modify_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_modify_sortorder", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_modify_temp_delete_delay", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_modify_topic", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_needed_delete_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_needed_description_view_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_needed_join_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_needed_modify_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_needed_permission_modify_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_needed_subscribe_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_permission_modify_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_channel_subscribe_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_avatar_delete_other", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_ban_create", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_ban_delete", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_ban_delete_own", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_ban_list", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_ban_max_bantime", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_ban_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_channel_textmessage_send", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_complain_delete", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_complain_delete_own", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_complain_list", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_complain_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_create_modify_serverquery_login", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_custom_info_view", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_delete_dbproperties", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_force_push_to_talk", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_ignore_antiflood", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_ignore_bans", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_ignore_sticky", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_info_view", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_is_priority_speaker", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_is_sticky", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_issue_client_query_command", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_kick_from_channel_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_kick_from_server_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_max_avatar_filesize", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_max_channel_subscriptions", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_max_clones_uid", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_max_idletime", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_modify_dbproperties", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_modify_description", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_modify_own_description", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_move_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_needed_ban_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_needed_complain_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_needed_kick_from_channel_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_needed_kick_from_server_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_needed_move_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_needed_permission_modify_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_needed_poke_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_needed_private_textmessage_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_needed_serverquery_view_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_needed_talk_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_needed_whisper_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_offline_textmessage_send", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_permission_modify_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_permissionoverview_own", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_permissionoverview_view", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_poke_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_private_textmessage_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_remoteaddress_view", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_request_talker", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_serverquery_view_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_server_textmessage_send", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_set_flag_talker", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_skip_channelgroup_permissions", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_talk_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_use_channel_commander", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_use_reserved_slot", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_client_whisper_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_ft_directory_create_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_ft_file_browse_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_ft_file_delete_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_ft_file_download_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_ft_file_rename_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_ft_file_upload_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_ft_ignore_password", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_ft_needed_directory_create_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_ft_needed_file_browse_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_ft_needed_file_delete_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_ft_needed_file_download_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_ft_needed_file_rename_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_ft_needed_file_upload_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_ft_quota_mb_download_per_client", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_ft_quota_mb_upload_per_client", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_ft_transfer_list", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_group_auto_update_max_value", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_group_auto_update_type", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_group_is_permanent", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_group_member_add_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_group_member_remove_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_group_modify_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_group_needed_member_add_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_group_needed_member_remove_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_group_needed_modify_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_group_show_name_in_tree", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_group_sort_id", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_icon_id", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_icon_manage", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_max_icon_filesize", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_permission_modify_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_permission_modify_power_ignore", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_serverinstance_binding_list", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_serverinstance_help_view", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_serverinstance_info_view", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_serverinstance_log_add", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_serverinstance_log_view", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_serverinstance_modify_querygroup", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_serverinstance_modify_settings", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_serverinstance_modify_templates", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_serverinstance_permission_find", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_serverinstance_permission_list", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_serverinstance_stop", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_serverinstance_textmessage_send", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_serverinstance_version_view", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_serverinstance_virtualserver_list", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_serverquery_login", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_change_machine_id", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_change_template", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_channelclient_permission_list", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_channelgroup_client_list", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_channelgroup_create", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_channelgroup_delete", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_channelgroup_list", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_channelgroup_permission_list", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_channel_list", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_channel_permission_list", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_channel_search", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_client_dbinfo", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_client_dblist", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_client_dbsearch", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_client_list", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_client_permission_list", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_client_search", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_connectioninfo_view", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_create", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_custom_search", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_delete", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_info_view", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_join_ignore_password", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_log_add", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_log_view", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_antiflood", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_autostart", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_channel_forced_silence", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_channel_temp_delete_delay_default", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_codec_encryption_mode", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_complain", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_default_channeladmingroup", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_default_channelgroup", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_default_servergroup", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_ft_quotas", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_ft_settings", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_hostbanner", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_hostbutton", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_hostmessage", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_icon_id", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_log_settings", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_maxclients", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_min_client_version", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_name", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_needed_identity_security_level", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_password", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_port", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_priority_speaker_dimm_modificator", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_reserved_slots", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_temporary_passwords", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_temporary_passwords_own", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_weblist", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_modify_welcomemessage", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_notify_register", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_notify_unregister", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_permission_find", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_permission_reset", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_select", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_servergroup_client_list", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_servergroup_create", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_servergroup_delete", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_servergroup_list", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_servergroup_permission_list", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_snapshot_create", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_snapshot_deploy", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_start", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_start_any", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_stop", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_stop_any", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_token_add", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_token_delete", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_token_list", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_needed_modify_power_virtualserver_token_use", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value,perm_negated, perm_skip) values (0, 2, 0, "i_permission_modify_power", 100, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_create_child", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_create_modify_with_codec_celtmono48", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_create_modify_with_codec_opusmusic", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_create_modify_with_codec_opusvoice", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_create_modify_with_codec_speex16", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_create_modify_with_codec_speex32", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_create_modify_with_codec_speex8", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_create_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_create_private", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_create_semi_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_create_temporary", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_create_with_default", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_create_with_description", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_create_with_maxclients", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_create_with_maxfamilyclients", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_create_with_needed_talk_power", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_create_with_password", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_create_with_sortorder", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_create_with_topic", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_delete_flag_force", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_delete_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_delete_semi_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_delete_temporary", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_info_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_join_ignore_maxclients", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_join_ignore_password", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_join_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_join_semi_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_join_temporary", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_modify_codec", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_modify_codec_latency_factor", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_modify_codec_quality", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_modify_description", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_modify_make_codec_encrypted", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_modify_make_default", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_modify_make_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_modify_make_semi_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_modify_make_temporary", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_modify_maxclients", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_modify_maxfamilyclients", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_modify_name", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_modify_needed_talk_power", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_modify_parent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_modify_password", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_modify_sortorder", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_modify_temp_delete_delay", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_channel_modify_topic", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_avatar_delete_other", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_ban_create", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_ban_delete", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_ban_delete_own", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_ban_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_channel_textmessage_send", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_complain_delete", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_complain_delete_own", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_complain_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_create_modify_serverquery_login", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_custom_info_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_delete_dbproperties", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_ignore_antiflood", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_ignore_bans", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_ignore_sticky", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_info_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_issue_client_query_command", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_modify_dbproperties", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_modify_description", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_modify_own_description", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_offline_textmessage_send", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_permissionoverview_own", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_permissionoverview_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_remoteaddress_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_request_talker", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_server_textmessage_send", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_set_flag_talker", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_skip_channelgroup_permissions", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_use_channel_commander", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_client_use_reserved_slot", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_ft_ignore_password", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_ft_transfer_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_group_is_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_icon_manage", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_channelclient_permission_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_channelgroup_client_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_channelgroup_create", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_channelgroup_delete", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_channelgroup_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_channelgroup_permission_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_channel_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_channel_permission_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_channel_search", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_client_dbinfo", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_client_dblist", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_client_dbsearch", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_client_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_client_permission_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_client_search", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_connectioninfo_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_custom_search", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_info_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_join_ignore_password", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_log_add", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_log_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_antiflood", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_autostart", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_channel_forced_silence", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_channel_temp_delete_delay_default", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_codec_encryption_mode", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_complain", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_default_channeladmingroup", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_default_channelgroup", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_default_servergroup", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_ft_quotas", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_ft_settings", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_hostbanner", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_hostbutton", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_hostmessage", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_icon_id", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_log_settings", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_maxclients", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_min_client_version", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_name", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_needed_identity_security_level", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_password", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_port", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_priority_speaker_dimm_modificator", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_reserved_slots", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_temporary_passwords", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_weblist", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_modify_welcomemessage", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_notify_register", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_notify_unregister", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_permission_find", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_servergroup_client_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_servergroup_create", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_servergroup_delete", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_servergroup_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_servergroup_permission_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_start", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_stop", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_token_add", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_token_delete", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_token_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_virtualserver_token_use", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_channel_create_modify_with_codec_latency_factor_min", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_channel_create_modify_with_codec_maxquality", 10, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_channel_create_modify_with_temp_delete_delay", 86400, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_channel_delete_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_channel_description_view_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_channel_join_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_channel_max_depth", 10, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_channel_modify_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_channel_permission_modify_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_channel_subscribe_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_ban_max_bantime", -1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_ban_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_complain_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_kick_from_channel_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_kick_from_server_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_max_avatar_filesize", 200000, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_max_channel_subscriptions", -1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_max_clones_uid", 10, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_move_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_needed_ban_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_needed_complain_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_needed_kick_from_channel_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_needed_kick_from_server_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_needed_move_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_needed_permission_modify_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_needed_serverquery_view_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_permission_modify_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_poke_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_private_textmessage_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_serverquery_view_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_talk_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_ft_directory_create_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_ft_file_browse_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_ft_file_delete_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_ft_file_download_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_ft_file_rename_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_ft_file_upload_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_ft_quota_mb_download_per_client", -1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_ft_quota_mb_upload_per_client", -1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_group_auto_update_max_value", 45, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_group_auto_update_type", 45, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_group_member_add_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_group_member_remove_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_group_modify_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_group_needed_member_add_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_group_needed_member_remove_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_group_needed_modify_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_icon_id", 300, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_max_icon_filesize", 8192, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_child", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_modify_with_codec_celtmono48", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_modify_with_codec_latency_factor_min", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_modify_with_codec_maxquality", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_modify_with_codec_opusmusic", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_modify_with_codec_opusvoice", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_modify_with_codec_speex16", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_modify_with_codec_speex32", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_modify_with_codec_speex8", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_modify_with_force_password", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_modify_with_temp_delete_delay", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_permanent", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_private", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_semi_permanent", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_temporary", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_with_default", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_with_description", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_with_maxclients", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_with_maxfamilyclients", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_with_needed_talk_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_with_password", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_with_sortorder", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_create_with_topic", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_delete_flag_force", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_delete_permanent", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_delete_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_delete_semi_permanent", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_delete_temporary", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_description_view_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_group_inheritance_end", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_info_view", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_join_ignore_maxclients", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_join_ignore_password", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_join_permanent", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_join_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_join_semi_permanent", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_join_temporary", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_max_depth", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_min_depth", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_modify_codec", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_modify_codec_latency_factor", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_modify_codec_quality", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_modify_description", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_modify_make_codec_encrypted", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_modify_make_default", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_modify_make_permanent", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_modify_make_semi_permanent", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_modify_make_temporary", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_modify_maxclients", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_modify_maxfamilyclients", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_modify_name", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_modify_needed_talk_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_modify_parent", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_modify_password", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_modify_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_modify_sortorder", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_modify_temp_delete_delay", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_modify_topic", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_needed_delete_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_needed_description_view_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_needed_join_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_needed_modify_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_needed_permission_modify_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_needed_subscribe_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_permission_modify_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_channel_subscribe_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_avatar_delete_other", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_ban_create", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_ban_delete", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_ban_delete_own", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_ban_list", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_ban_max_bantime", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_ban_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_channel_textmessage_send", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_complain_delete", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_complain_delete_own", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_complain_list", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_complain_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_create_modify_serverquery_login", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_custom_info_view", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_delete_dbproperties", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_force_push_to_talk", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_ignore_antiflood", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_ignore_bans", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_ignore_sticky", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_info_view", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_is_priority_speaker", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_is_sticky", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_issue_client_query_command", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_kick_from_channel_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_kick_from_server_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_max_avatar_filesize", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_max_channel_subscriptions", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_max_clones_uid", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_max_idletime", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_modify_dbproperties", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_modify_description", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_modify_own_description", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_move_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_needed_ban_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_needed_complain_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_needed_kick_from_channel_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_needed_kick_from_server_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_needed_move_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_needed_permission_modify_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_needed_poke_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_needed_private_textmessage_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_needed_serverquery_view_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_needed_talk_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_needed_whisper_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_offline_textmessage_send", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_permission_modify_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_permissionoverview_own", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_permissionoverview_view", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_poke_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_private_textmessage_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_remoteaddress_view", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_request_talker", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_serverquery_view_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_server_textmessage_send", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_set_flag_talker", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_skip_channelgroup_permissions", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_talk_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_use_channel_commander", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_use_reserved_slot", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_client_whisper_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_ft_directory_create_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_ft_file_browse_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_ft_file_delete_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_ft_file_download_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_ft_file_rename_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_ft_file_upload_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_ft_ignore_password", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_ft_needed_directory_create_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_ft_needed_file_browse_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_ft_needed_file_delete_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_ft_needed_file_download_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_ft_needed_file_rename_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_ft_needed_file_upload_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_ft_quota_mb_download_per_client", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_ft_quota_mb_upload_per_client", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_ft_transfer_list", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_group_auto_update_type", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_group_is_permanent", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_group_member_add_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_group_member_remove_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_group_modify_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_group_needed_member_add_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_group_needed_member_remove_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_group_needed_modify_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_group_show_name_in_tree", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_group_sort_id", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_icon_id", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_icon_manage", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_max_icon_filesize", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_permission_modify_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_channelclient_permission_list", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_channelgroup_client_list", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_channelgroup_create", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_channelgroup_delete", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_channelgroup_list", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_channelgroup_permission_list", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_channel_list", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_channel_permission_list", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_channel_search", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_client_dbinfo", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_client_dblist", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_client_dbsearch", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_client_list", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_client_permission_list", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_client_search", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_connectioninfo_view", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_custom_search", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_info_view", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_join_ignore_password", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_log_add", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_log_view", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_antiflood", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_autostart", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_channel_forced_silence", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_channel_temp_delete_delay_default", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_codec_encryption_mode", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_complain", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_default_channeladmingroup", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_default_channelgroup", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_default_servergroup", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_ft_quotas", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_ft_settings", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_hostbanner", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_hostbutton", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_hostmessage", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_icon_id", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_log_settings", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_maxclients", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_min_client_version", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_name", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_needed_identity_security_level", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_password", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_port", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_priority_speaker_dimm_modificator", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_reserved_slots", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_temporary_passwords", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_temporary_passwords_own", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_weblist", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_modify_welcomemessage", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_notify_register", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_notify_unregister", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_permission_find", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_servergroup_client_list", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_servergroup_create", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_servergroup_delete", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_servergroup_list", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_servergroup_permission_list", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_start", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_stop", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_token_add", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_token_delete", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_token_list", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_needed_modify_power_virtualserver_token_use", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_permission_modify_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_channel_create_child", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_channel_create_modify_with_codec_opusvoice", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_channel_create_modify_with_codec_speex16", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_channel_create_modify_with_codec_speex32", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_channel_create_modify_with_codec_speex8", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_channel_create_private", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_channel_create_semi_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_channel_create_temporary", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_channel_create_with_description", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_channel_create_with_maxclients", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_channel_create_with_maxfamilyclients", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_channel_create_with_needed_talk_power", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_channel_create_with_password", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_channel_create_with_topic", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_channel_info_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_channel_join_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_channel_join_semi_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_channel_join_temporary", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_client_channel_textmessage_send", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_client_info_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_client_offline_textmessage_send", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_client_permissionoverview_own", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_client_permissionoverview_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_client_request_talker", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_group_is_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_virtualserver_channelgroup_client_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_virtualserver_channelgroup_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_virtualserver_channel_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_virtualserver_client_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_virtualserver_connectioninfo_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_virtualserver_info_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_virtualserver_servergroup_client_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_virtualserver_servergroup_list", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "b_virtualserver_token_use", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_channel_create_modify_with_codec_latency_factor_min", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_channel_create_modify_with_codec_maxquality", 7, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_channel_description_view_power", 50, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_channel_join_power", 50, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_channel_max_depth", 5, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_channel_modify_power", 50, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_channel_subscribe_power", 50, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_client_complain_power", 50, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_client_max_avatar_filesize", 200000, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_client_max_channel_subscriptions", -1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_client_max_clones_uid", 2, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_client_needed_ban_power", 50, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_client_needed_complain_power", 50, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_client_needed_kick_from_channel_power", 50, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_client_needed_kick_from_server_power", 50, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_client_needed_move_power", 50, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_client_needed_serverquery_view_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_client_poke_power", 50, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_client_private_textmessage_power", 50, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_ft_directory_create_power", 50, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_ft_file_browse_power", 50, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_ft_file_delete_power", 50, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_ft_file_download_power", 50, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_ft_file_rename_power", 50, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_ft_file_upload_power", 50, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_ft_quota_mb_download_per_client", -1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_ft_quota_mb_upload_per_client", -1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_group_auto_update_type", 30, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_group_needed_member_add_power", 60, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_group_needed_member_remove_power", 60, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_group_needed_modify_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "b_channel_create_modify_with_codec_opusvoice", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "b_channel_create_modify_with_codec_speex16", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "b_channel_create_modify_with_codec_speex8", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "b_channel_create_temporary", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "b_channel_create_with_maxclients", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "b_channel_create_with_needed_talk_power", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "b_channel_create_with_password", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "b_channel_create_with_topic", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "b_channel_info_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "b_channel_join_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "b_channel_join_semi_permanent", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "b_channel_join_temporary", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "b_client_channel_textmessage_send", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "b_client_info_view", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "b_client_request_talker", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "b_virtualserver_token_use", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "i_channel_create_modify_with_codec_latency_factor_min", 1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "i_channel_create_modify_with_codec_maxquality", 7, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "i_channel_max_depth", 0, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "i_client_max_avatar_filesize", 200000, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "i_client_max_channel_subscriptions", -1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "i_client_max_clones_uid", 0, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "i_client_needed_ban_power", 25, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "i_client_needed_kick_from_channel_power", 25, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "i_client_needed_kick_from_server_power", 25, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "i_client_needed_move_power", 25, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "i_client_needed_serverquery_view_power", 75, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "i_ft_file_browse_power", 25, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "i_ft_file_download_power", 25, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "i_ft_quota_mb_download_per_client", -1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "i_ft_quota_mb_upload_per_client", -1, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "i_group_auto_update_type", 15, 0, 0);
insert into perm_server_group (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 5, 0, "i_group_needed_modify_power", 75, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_channel_delete_flag_force", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_channel_delete_semi_permanent", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_channel_delete_temporary", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_channel_modify_codec", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_channel_modify_codec_latency_factor", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_channel_modify_codec_quality", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_channel_modify_description", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_channel_modify_make_codec_encrypted", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_channel_modify_make_temporary", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_channel_modify_maxclients", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_channel_modify_maxfamilyclients", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_channel_modify_name", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_channel_modify_needed_talk_power", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_channel_modify_password", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_channel_modify_topic", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_client_set_flag_talker", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_client_use_channel_commander", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "b_group_is_permanent", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "i_channel_create_modify_with_codec_latency_factor_min", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "i_channel_delete_power", 50, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "i_channel_description_view_power", 50, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "i_client_kick_from_channel_power", 50, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "i_client_move_power", 50, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "i_client_needed_complain_power", 25, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "i_client_needed_kick_from_channel_power", 50, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "i_client_talk_power", 60, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "i_group_auto_update_type", 40, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "i_group_member_add_power", 50, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "i_group_member_remove_power", 50, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "i_group_needed_member_add_power", 50, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "i_group_needed_member_remove_power", 50, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "i_group_needed_modify_power", 75, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 1, 0, "i_icon_id", 100, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 2, 0, "b_client_set_flag_talker", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 2, 0, "b_group_is_permanent", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 2, 0, "i_client_needed_complain_power", 25, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 2, 0, "i_client_talk_power", 50, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 2, 0, "i_group_auto_update_type", 35, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 2, 0, "i_group_member_add_power", 30, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 2, 0, "i_group_member_remove_power", 30, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 2, 0, "i_group_needed_member_add_power", 30, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 2, 0, "i_group_needed_member_remove_power", 30, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 2, 0, "i_group_needed_modify_power", 75, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 2, 0, "i_icon_id", 200, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "b_group_is_permanent", 1, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_client_talk_power", 25, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_group_auto_update_type", 25, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_group_needed_member_add_power", 25, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_group_needed_member_remove_power", 25, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_group_needed_modify_power", 75, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 3, 0, "i_icon_id", 600, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_group_auto_update_type", 10, 0, 0);
insert into perm_channel_groups (server_id, id1, id2, perm_id, perm_value, perm_negated, perm_skip) values (0, 4, 0, "i_group_needed_modify_power", 75, 0, 0);
/*END AUTOCODE*/
